function createfigure(YMatrix1, YMatrix2)
%CREATEFIGURE(YMatrix1, YMatrix2)
%  YMATRIX1:  matrix of semilogy y data
%  YMATRIX2:  matrix of semilogy y data

%  Auto-generated by MATLAB on 27-Jun-2023 12:30:21

% Create figure
figure('WindowState','maximized');

% Create subplot
subplot1 = subplot(2,1,1);
hold(subplot1,'on');

% Create multiple line objects using matrix input to semilogy
semilogy1 = semilogy(YMatrix1,'LineWidth',4.5);
set(semilogy1(1),'DisplayName','NNAG');
set(semilogy1(2),'DisplayName','Per-FE-C');
set(semilogy1(3),...
    'DisplayName','Perturbed Gradient Descent + Gaussian Noise');

% Create ylabel
ylabel('$\log(f(x_k)-f(x^*))$','FontName','Times New Roman',...
    'Interpreter','latex');

% Create xlabel
xlabel('Epoch','FontName','Times New Roman');

hold(subplot1,'off');
% Set the remaining axes properties
set(subplot1,'FontName','Times New Roman','FontSize',36,'LineWidth',3.5,...
    'XGrid','on','XTickLabel',...
    {'0','10','20','30','40','50','60','70','80','90','100'},'YGrid','on',...
    'YMinorTick','on','YScale','log','YTick',[0.001 0.01 0.1 1],'YTickLabel',...
    {'10^{-3}','10^{-2}','10^{-1}','10^{0}'});
% Create legend
legend1 = legend(subplot1,'show');
set(legend1,...
    'Position',[0.491413145068998 0.72400355639598 0.407373251738372 0.130375143543828],...
    'Interpreter','latex');

% Create subplot
subplot2 = subplot(2,1,2);
hold(subplot2,'on');

% Create multiple line objects using matrix input to semilogy
semilogy2 = semilogy(YMatrix2,'LineWidth',4.5);
set(semilogy2(1),'DisplayName','SGD','LineWidth',3,...
    'Color',[0.494117647058824 0.184313725490196 0.556862745098039]);
set(semilogy2(2),'DisplayName','SVRG',...
    'Color',[0.850980392156863 0.325490196078431 0.0980392156862745]);
set(semilogy2(3),'DisplayName','NNAG + SGD Gradients',...
    'Color',[0 0.447058823529412 0.741176470588235]);
set(semilogy2(4),'DisplayName','NNAG + SVRG Gradients',...
    'Color',[0.466666666666667 0.674509803921569 0.188235294117647]);

% Create ylabel
ylabel('$\log(f(x_k)-f(x^*))$','FontName','Times New Roman',...
    'Interpreter','latex');

% Create xlabel
xlabel('Epoch','FontName','Times New Roman');

% Uncomment the following line to preserve the X-limits of the axes
% xlim(subplot2,[0 200000]);
% Uncomment the following line to preserve the Y-limits of the axes
% ylim(subplot2,[5.18654136772037e-16 1.21835939942099]);
hold(subplot2,'off');
% Set the remaining axes properties
set(subplot2,'FontName','Times New Roman','FontSize',36,'LineWidth',3.5,...
    'XGrid','on','XTick',...
    [0 20000 40000 60000 80000 100000 120000 140000 160000 180000 200000],...
    'XTickLabel',{'0','10','20','30','40','50','60','70','80','90','100'},...
    'YGrid','on','YMinorTick','on','YScale','log','YTick',[1e-15 1e-10 1e-05 1],...
    'YTickLabel',{'10^{-15}','10^{-10}','10^{-5}','10^{0}'});
% Create legend
legend2 = legend(subplot2,'show');
set(legend2,...
    'Position',[0.572945119711884 0.24779793861115 0.322089499897427 0.0881672089506192],...
    'NumColumns',2,...
    'Interpreter','latex');

